﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SampleSerialization
{
    public class MyDTOProcessor : gdio.plugin.serializer.ICustomSerializer
    {
        public MyDTOProcessor() { }
        public object Deserialize(byte[] rawObject)
        {
            string data = Encoding.ASCII.GetString(rawObject);

            if(!data.StartsWith("$CustomColor:"))
                throw new NotImplementedException();

            data = data.Substring("$CustomColor:".Length);

            string[] parts = data.Split(new char[] { '|' });

            return new CustomColor(int.Parse(parts[0]), int.Parse(parts[1]), int.Parse(parts[2]), int.Parse(parts[3]));
        }

        public byte[] Serialize(object theObject)
        {
            if(!theObject.GetType().Equals(typeof(CustomColor)))
                throw new NotImplementedException();

            return Encoding.ASCII.GetBytes($"$CustomColor:{(theObject as CustomColor).m_R}|{(theObject as CustomColor).m_G}|{(theObject as CustomColor).m_B}|{(theObject as CustomColor).m_A}");
        }

        public Type[] SupportedTypes()
        {
            return new Type[] { typeof(CustomColor) };
        }
    }

}
