﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SampleSerialization
{
    public class CustomColor : IEquatable<CustomColor>
    {
        public int m_R = 0;
        public int m_G = 0;
        public int m_B = 0;
        public int m_A = 0;

        public Guid Id = Guid.NewGuid();
        public CustomColor(int r, int g, int b, int a)
        {
            m_R = r; m_G = g; m_B = b; m_A = a;           
        }

        public override int GetHashCode()
        {
            return Id.GetHashCode();
        }
        public bool Equals(CustomColor other)
        {
            if (ReferenceEquals(null, other))
            {
                return false;
            }

            return m_R == other.m_R &&
                   m_G == other.m_G &&
                   m_B == other.m_B &&
                   m_A == other.m_A;
        }
    }
}
